//
//  MCDoNotRemindPanel.h
//  MCApplication
//
//  Created by Ali Lalani on 11/05/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCWindowController.h>

@interface MCDoNotRemindPanel : MCWindowController {
	NSString *_okString;
	NSString *_details;
	NSString *_title;
	NSString *_defaultsIdentifier;
	NSImage  *_image;
	BOOL _okAsDefault;
	BOOL hideDoNotRemind;
	
	IBOutlet NSButton *doNotRemindCheckbox;
	IBOutlet NSButton *okButton;
    IBOutlet NSButton *cancelButton;
    
	int resultCode;
}

+ (MCDoNotRemindPanel *)runPanelWithDefaultIdentifier:(NSString *)anIdentifier
										  titleString:(NSString *)title
										  description:(NSString *)desc
											 okString:(NSString *)ok
												image:(NSImage *)image;

+ (MCDoNotRemindPanel *)runPanelWithDefaultIdentifier:(NSString *)anIdentifier
										  titleString:(NSString *)title
										  description:(NSString *)desc
											 okString:(NSString *)ok
												image:(NSImage *)image
											okDefault:(BOOL)okDefault;

//If hideDoNotRemindOption is YES then the default is ignored as well
+ (MCDoNotRemindPanel *)runPanelWithDefaultIdentifier:(NSString *)anIdentifier
										  titleString:(NSString *)title
										  description:(NSString *)desc
											 okString:(NSString *)ok
												image:(NSImage *)image
											okDefault:(BOOL)okDefault
								hideDoNotRemindOption:(BOOL)hideDoNotRemindFlag;

- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;

- (void)dismiss;

- (BOOL)hideDoNotRemind;
- (void)setHideDoNotRemind:(BOOL)flag;
- (void)setOkAsDefaultButton:(BOOL)okAsDefault;
- (NSString *)okString;
- (void)setOkString:(NSString *)anOkString;
- (NSString *)details;
- (void)setDetails:(NSString *)aDescription;
- (NSString *)title;
- (void)setTitle:(NSString *)aTitle;
- (int)resultCode;
- (void)setResultCode:(int)aResultCode;
- (NSString *)defaultsIdentifier;
- (void)setDefaultsIdentifier:(NSString *)aDefaultsIdentifier;
- (NSImage *)image;
- (void)setImage:(NSImage *)anImage;
@end
